// Socket.h
//
//////////////////////////////////////////////////////////////////////

#ifndef _SOCKET_H_
#define _SOCKET_H_

#pragma comment( lib, "wsock32.lib" ) 

#include <winsock.h>
#include <sys/types.h>
#include <process.h>

#include <iostream>
#include <string>
#include <list>
#include <deque>
#include <fstream>

using namespace std;


#define ADDRFILE "AddressInfo.txt"	// AhX񂪏ꂽt@C
#define MMI_MODULE_NAME_LENGTH		15				// W[15܂
#define RECV_BUFFER_SIZE			256				// recv()̎Mpobt@TCY

#define WM_MMIMSG_QUEUED			WM_USER+1

// sockaddr_in\̂bvNX
class CSockAddr
{

protected:

	struct sockaddr_in m_InetSockAddr;		// C^[lbgp\PbgAhX\

public:

	CSockAddr();
	CSockAddr( const char *IpAddr, const int nPort );
	CSockAddr( const CSockAddr &Addr );
	virtual ~CSockAddr();

	CSockAddr& operator = ( const CSockAddr &Addr );

	// IPAhXƃ|[gԍZbg
	void Set( const char *IpAddr, const int nPort );

	// ZbgĂ|[gԍԂ
	int GetPort() const;
	// IPAhXԂ
	const char* GetIpAddr() const;
	// õ|C^Ԃ
	const struct sockaddr* GetSockaddr() const;
	const struct sockaddr_in* GetSockaddrIN() const;

};

// MMIVXep
// W[̃AhXǗ
class CMMIModuleAddr : public CSockAddr
{

private:

	char m_szModule[ MMI_MODULE_NAME_LENGTH + 1 ];	// W[

public:

	CMMIModuleAddr();
	CMMIModuleAddr( const char *szName, const char *IpAddr, const int nPort );
	CMMIModuleAddr( const CMMIModuleAddr &Addr );
	virtual ~CMMIModuleAddr();

	CMMIModuleAddr& operator = ( const CMMIModuleAddr &Addr );

	// W[AIPAhXA|[gԍ܂Ƃ߂ăZbg
	void Set( const char *Module, const char *IpAddr, const int nPort );

	// W[Ԃ
	const char* GetName() const;

};

// ubLO\Pbg̃bv
class CSock
{

public:
	SOCKET m_hSocket;	// \Pbgnh

public:
	CSock();
	virtual ~CSock();


	void Attach( SOCKET hSocket );
	void Detach();

	BOOL Socket( int nAddrFamily = AF_INET, int nSocketType = SOCK_STREAM, int nProtocol = IPPROTO_TCP );
	BOOL Bind( CSockAddr *addr );
	BOOL Listen( int nMaxCon = 5 );
	BOOL Accept( CSock &sock );
	BOOL Connect( CSockAddr *addr );
	void Close();

	int Send( LPCSTR sMsg, size_t nByte );

	int Recv( LPSTR sBuff );

	BOOL IsValid();

};

// W[ԒʐMpbZ[W̃bv
class CComMsg
{
public:

	string m_Msg;			// bZ[W

protected:

	string GetSubstring( const char *szTag ) const;

public:

	CComMsg();
	CComMsg( string &msg );
	CComMsg( const CComMsg &msg );
	virtual ~CComMsg();

	CComMsg& operator = ( const CComMsg &msg );

	void Set( string &msg );

	string Get();
	string GetCmd() const;
	string GetFrom() const;
	string GetTo() const;

	void Dump();

};

// bZ[WMp̃NX
class CMsgServer
{

protected:

	char m_szModule[ MMI_MODULE_NAME_LENGTH + 1 ];				// W[
	list < CMMIModuleAddr* > m_Addrlist;	// AhXXg
	CSock m_Socket;							// ڑҋ@p\Pbg
	DWORD m_dwThread;						// MpXbh̃nh
	HWND m_hWnd;

	deque < CComMsg* > m_MsgDeque;			// 
	CRITICAL_SECTION m_CriticalSection;		// ftHgbZ[WL[p

	

public:

	CMsgServer();
	virtual ~CMsgServer();
	
	// 
	BOOL Initialize( LPCSTR szModule, HWND hWnd = NULL );
	
	// T[o[̊Jnƒ~
	void Run();
	void Stop();

	// L[烁bZ[Wo
	virtual BOOL GetMsg( CComMsg &msg );
	virtual BOOL GetMsg( string &msg );

	// bZ[W𑗐M
	BOOL SendMsg( CComMsg &msg );
	BOOL SendMsg( string &msg );
	
	BOOL SendMsg( LPCTSTR lpszMsg, LPCTSTR lpszAddrTo );

protected:

	void WinSockInit();
	
	// AhXt@C̓ǂݍ
	void ReadAddrFile( LPCSTR szFile );
	// AhXNA
	void ClearAddr();
	// W[AhXQ
	CMMIModuleAddr* GetAddr( LPCSTR szModule );
	
	// MpXbh
	static void  RecvThread( void* );
	
	// MbZ[W
	virtual void AnalyzeMessage( string &msg );	

};

#endif _SOCKET_H_